package nemosofts.voxradio.utils.helper;

import android.annotation.SuppressLint;
import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.LinearLayout;
import android.widget.TextView;
import android.widget.Toast;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.nemosofts.material.SmoothCheckBox;
import androidx.nemosofts.utils.EncrypterUtils;
import androidx.nemosofts.utils.NetworkUtils;

import com.applovin.mediation.MaxAd;
import com.applovin.mediation.MaxAdListener;
import com.applovin.mediation.MaxError;
import com.applovin.mediation.MaxReward;
import com.applovin.mediation.MaxRewardedAdListener;
import com.applovin.mediation.ads.MaxAdView;
import com.applovin.sdk.AppLovinMediationProvider;
import com.applovin.sdk.AppLovinSdk;
import com.applovin.sdk.AppLovinSdkInitializationConfiguration;
import com.google.ads.mediation.admob.AdMobAdapter;
import com.google.ads.mediation.facebook.FacebookMediationAdapter;
import com.google.android.gms.ads.AdRequest;
import com.google.android.gms.ads.AdSize;
import com.google.android.gms.ads.AdView;
import com.google.android.gms.ads.FullScreenContentCallback;
import com.google.android.gms.ads.MobileAds;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.firebase.auth.FirebaseAuth;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonObject;
import com.ironsource.mediationsdk.ISBannerSize;
import com.ironsource.mediationsdk.IronSource;
import com.ironsource.mediationsdk.IronSourceBannerLayout;
import com.ironsource.mediationsdk.adunit.adapter.utility.AdInfo;
import com.ironsource.mediationsdk.logger.IronSourceError;
import com.ironsource.mediationsdk.sdk.LevelPlayInterstitialListener;
import com.startapp.sdk.ads.banner.Banner;
import com.startapp.sdk.adsbase.Ad;
import com.startapp.sdk.adsbase.StartAppAd;
import com.startapp.sdk.adsbase.StartAppSDK;
import com.startapp.sdk.adsbase.adlisteners.AdDisplayListener;
import com.unity3d.ads.IUnityAdsInitializationListener;
import com.unity3d.ads.IUnityAdsShowListener;
import com.unity3d.ads.UnityAds;
import com.unity3d.services.banners.BannerView;
import com.unity3d.services.banners.UnityBannerSize;
import com.yandex.mobile.ads.banner.BannerAdView;
import com.yandex.mobile.ads.common.AdError;
import com.yandex.mobile.ads.common.ImpressionData;
import com.yandex.mobile.ads.interstitial.InterstitialAdEventListener;

import org.jetbrains.annotations.NotNull;

import java.io.File;
import java.util.Arrays;

import nemosofts.voxradio.R;
import nemosofts.voxradio.activity.SignInActivity;
import nemosofts.voxradio.callback.Callback;
import nemosofts.voxradio.callback.Method;
import nemosofts.voxradio.dialog.DialogUtil;
import nemosofts.voxradio.interfaces.InterAdListener;
import nemosofts.voxradio.interfaces.RewardAdListener;
import nemosofts.voxradio.utils.ApplicationUtil;
import nemosofts.voxradio.utils.advertising.AdManagerInterAdmob;
import nemosofts.voxradio.utils.advertising.AdManagerInterApplovin;
import nemosofts.voxradio.utils.advertising.AdManagerInterStartApp;
import nemosofts.voxradio.utils.advertising.AdManagerInterUnity;
import nemosofts.voxradio.utils.advertising.AdManagerInterYandex;
import nemosofts.voxradio.utils.advertising.GDPRChecker;
import nemosofts.voxradio.utils.advertising.RewardAdAdmob;
import nemosofts.voxradio.utils.advertising.RewardAdApplovin;
import nemosofts.voxradio.utils.advertising.RewardAdStartApp;
import nemosofts.voxradio.utils.advertising.RewardAdUnity;
import okhttp3.MediaType;
import okhttp3.MultipartBody;
import okhttp3.RequestBody;

public class Helper {

    private static final String TAG = "Helper";
    private final Context ctx;
    private InterAdListener interAdListener;
    boolean isRewarded = false;

    public Helper(Context ctx) {
        this.ctx = ctx;
    }

    public Helper(Context ctx, InterAdListener interAdListener) {
        this.ctx = ctx;
        this.interAdListener = interAdListener;
    }

    public RequestBody getAPIRequest(String helperName, int page, String itemID, String catID,
                                     String searchText, String reportMessage, String userID, String name,
                                     String email, String mobile, String gender, String password, String
                                             authID, String loginType, File file) {

        Gson gson = new GsonBuilder().setDateFormat("yyyy-MM-dd' 'HH:mm:ss").create();
        JsonObject jsObj = (JsonObject) new Gson().toJsonTree(gson);
        jsObj.addProperty("helper_name", helperName);
        jsObj.addProperty("application_id", ctx.getPackageName());

        final String TAG_USER_ID = "user_id";
        final String TAG_USER_EMAIL = "user_email";
        final String TAG_USER_PASSWORD = "user_password";

        final String TAG_POST_ID = "post_id";
        final String TAG_SEARCH_TEXT = "search_text";
        final String TAG_SEARCH_TYPE = "search_type";
        final String TAG_PAGE = "page";

        if (Method.METHOD_APP_DETAILS.equals(helperName)){
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_LOGIN.equals(helperName)){
            jsObj.addProperty(TAG_USER_EMAIL, email);
            jsObj.addProperty(TAG_USER_PASSWORD, password);
            jsObj.addProperty("auth_id", authID);
            jsObj.addProperty("type", loginType);
        } else if (Method.METHOD_REGISTER.equals(helperName)){
            jsObj.addProperty("user_name", name);
            jsObj.addProperty(TAG_USER_EMAIL, email);
            jsObj.addProperty("user_phone", mobile);
            jsObj.addProperty("user_gender", gender);
            jsObj.addProperty(TAG_USER_PASSWORD, password);
            jsObj.addProperty("auth_id", authID);
            jsObj.addProperty("type", loginType);
        } else if (Method.METHOD_PROFILE.equals(helperName)) {
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_ACCOUNT_DELETE.equals(helperName)) {
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_EDIT_PROFILE.equals(helperName)){
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty("user_name", name);
            jsObj.addProperty(TAG_USER_EMAIL, email);
            jsObj.addProperty("user_phone", mobile);
            jsObj.addProperty(TAG_USER_PASSWORD, password);
        } else if (Method.METHOD_USER_IMAGES_UPDATE.equals(helperName)){
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty("type", loginType);
        } else if (Method.METHOD_FORGOT_PASSWORD.equals(helperName)){
            jsObj.addProperty(TAG_USER_EMAIL, email);
        } else if (Method.METHOD_REPORT.equals(helperName)) {
            jsObj.addProperty(TAG_POST_ID, itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty("report_title", searchText);
            jsObj.addProperty("report_msg", reportMessage);
        } else if (Method.METHOD_GET_RATINGS.equals(helperName)) {
            jsObj.addProperty(TAG_POST_ID, itemID);
            jsObj.addProperty("device_id", userID);
        } else if (Method.METHOD_RATINGS.equals(helperName)) {
            jsObj.addProperty(TAG_POST_ID, itemID);
            jsObj.addProperty("device_id", userID);
            jsObj.addProperty("rate", authID);
            jsObj.addProperty("message", reportMessage);
        }

        else if (Method.METHOD_HOME.equals(helperName)) {
            jsObj.addProperty(TAG_USER_ID, userID);
            if(!itemID.isEmpty()) {
                jsObj.addProperty("radio_ids", itemID);
            }
        } else if (Method.METHOD_HOME_DETAILS.equals(helperName)) {
            jsObj.addProperty("id", itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_DO_FAV.equals(helperName)
                || Method.METHOD_REMOVE_NOTIFICATION.equals(helperName)) {
            jsObj.addProperty(TAG_POST_ID, itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_LATEST.equals(helperName)
                | Method.METHOD_MOST_VIEWED.equals(helperName)
                || Method.METHOD_NOTIFICATION.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_RADIO_RECENT.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty("radio_ids", itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_CAT.equals(helperName)
                || Method.METHOD_COU.equals(helperName)
                || Method.METHOD_PODCASTS.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty(TAG_SEARCH_TEXT, searchText);
            jsObj.addProperty(TAG_SEARCH_TYPE, loginType);
        } else if (Method.METHOD_SINGLE_RADIO.equals(helperName)) {
            jsObj.addProperty("radio_id", itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_SEARCH_RADIO.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty(TAG_SEARCH_TEXT, searchText);
            jsObj.addProperty(TAG_USER_ID, userID);
        } else if (Method.METHOD_SUGGESTION.equals(helperName)) {
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty("suggest_title", searchText);
            jsObj.addProperty("suggest_message", reportMessage);
        } else if (Method.METHOD_SEARCH.equals(helperName)) {
            jsObj.addProperty(TAG_SEARCH_TEXT, searchText);
            jsObj.addProperty(TAG_USER_ID, userID);
        }

        else if (Method.METHOD_RADIO_BY_COU.equals(helperName)) {
            jsObj.addProperty("cou_id", catID);
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
        } else if (Method.METHOD_RADIO_BY_CAT.equals(helperName)) {
            jsObj.addProperty("cat_id", catID);
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
        } else if (Method.METHOD_RADIO_BY_BANNER.equals(helperName)) {
            jsObj.addProperty("banner_id", itemID);
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
        }  else if (Method.METHOD_POST_BY_FAV.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty(TAG_USER_ID, userID);
            jsObj.addProperty("type", loginType);
        }  else if (Method.METHOD_PODCASTS_BY.equals(helperName)) {
            jsObj.addProperty(TAG_PAGE, String.valueOf(page));
            jsObj.addProperty("podcasts_id", itemID);
        }

        if (helperName.equals(Method.METHOD_REGISTER)
                || helperName.equals(Method.METHOD_SUGGESTION)
                || helperName.equals(Method.METHOD_USER_IMAGES_UPDATE)) {
            final MediaType mediaType = MediaType.parse("image/*");
            MultipartBody.Builder builder = new MultipartBody.Builder().setType(MultipartBody.FORM);
            if (file != null) {
                builder.addFormDataPart("image_data", file.getName(), RequestBody.create(mediaType, file));
            }
            return builder.addFormDataPart("data", EncrypterUtils.toBase64(jsObj.toString())).build();
        }
        return new MultipartBody.Builder()
                .setType(MultipartBody.FORM)
                .addFormDataPart("data", EncrypterUtils.toBase64(jsObj.toString()))
                .build();
    }

    public void initializeAds() {
        try {
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_ADMOB) || Callback.getAdNetwork().equals(Callback.AD_TYPE_META)) {
                MobileAds.initialize(ctx, initializationStatus -> {
                });
            }
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_STARTAPP)) {
                StartAppSDK.init(ctx, Callback.getStartappAppID());
                StartAppAd.disableSplash();
                StartAppSDK.setUserConsent(ctx, "pas", System.currentTimeMillis(), new GDPRChecker(ctx).canLoadAd());
            }
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_APPLOVIN) && (!AppLovinSdk.getInstance(ctx).isInitialized())) {
                AppLovinSdkInitializationConfiguration initConfig = AppLovinSdkInitializationConfiguration.builder(ctx.getString(R.string.applovin_sdk_key))
                        .setMediationProvider(AppLovinMediationProvider.MAX)
                        .setTestDeviceAdvertisingIds(Arrays.asList("656822d9-18de-4120-994e-44d4245a4d63", "249d75a2-1ef2-8ff9-8885-c50384843a66"))
                        .build();

                // Initialize the SDK with the configuration
                AppLovinSdk.getInstance( ctx ).initialize(initConfig, sdkConfig -> {
                });
            }
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_IRONSOURCE)) {
                IronSource.init(ctx, Callback.getIronsourceAppKey(), () -> {
                });
            }
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_UNITY)) {
                UnityAds.initialize(ctx, Callback.getUnityGameID(), true, new IUnityAdsInitializationListener() {
                    @Override
                    public void onInitializationComplete() {
                        // document why this method is empty
                    }

                    @Override
                    public void onInitializationFailed(UnityAds.UnityAdsInitializationError error, String message) {
                        // document why this method is empty
                    }
                });
            }
            if (Callback.getAdNetwork().equals(Callback.AD_TYPE_YANDEX)) {
                com.yandex.mobile.ads.common.MobileAds.initialize(ctx, () -> {
                });
            }
        } catch (Exception e) {
            ApplicationUtil.log(TAG,"Error ads load");
        }
    }

    public Object showBannerAd(LinearLayout linearLayout, String page) {
        if (isBannerAd(page)){
            switch (Callback.getAdNetwork()) {
                case Callback.AD_TYPE_ADMOB, Callback.AD_TYPE_META -> {
                    Bundle extras = new Bundle();
                    AdView adViewAdmob = new AdView(ctx);
                    AdRequest adRequest;
                    if (Callback.getAdNetwork().equals(Callback.AD_TYPE_ADMOB)) {
                        adRequest = new AdRequest.Builder()
                                .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                                .build();
                    } else {
                        adRequest = new AdRequest.Builder()
                                .addNetworkExtrasBundle(AdMobAdapter.class, extras)
                                .addNetworkExtrasBundle(FacebookMediationAdapter.class, extras)
                                .build();
                    }
                    adViewAdmob.setAdUnitId(Callback.getAdmobBannerAdID());
                    adViewAdmob.setAdSize(AdSize.BANNER);
                    linearLayout.addView(adViewAdmob);
                    adViewAdmob.loadAd(adRequest);
                    return adViewAdmob;
                }
                case Callback.AD_TYPE_STARTAPP -> {
                    Banner startAppBanner = new Banner(ctx);
                    startAppBanner.setLayoutParams(new ViewGroup.LayoutParams(ViewGroup.LayoutParams.MATCH_PARENT, ViewGroup.LayoutParams.WRAP_CONTENT));
                    linearLayout.addView(startAppBanner);
                    startAppBanner.loadAd();
                    return startAppBanner;
                }
                case Callback.AD_TYPE_UNITY -> {
                    BannerView bannerView = new BannerView((Activity) ctx, Callback.getUnityBannerAdID(), new UnityBannerSize(320, 50));
                    linearLayout.addView(bannerView);
                    bannerView.load();
                    return bannerView;
                }
                case Callback.AD_TYPE_APPLOVIN -> {
                    MaxAdView adView = new MaxAdView(Callback.getApplovinBannerAdID(), ctx);
                    int width = ViewGroup.LayoutParams.MATCH_PARENT;
                    int heightPx = ctx.getResources().getDimensionPixelSize(R.dimen.banner_height);
                    adView.setLayoutParams(new FrameLayout.LayoutParams(width, heightPx));
                    linearLayout.addView(adView);
                    adView.loadAd();
                    return adView;
                }
                case Callback.AD_TYPE_IRONSOURCE -> {
                    IronSourceBannerLayout iBannerAd = IronSource.createBanner((Activity) ctx, ISBannerSize.BANNER);
                    linearLayout.addView(iBannerAd);
                    IronSource.loadBanner(iBannerAd);
                    return iBannerAd;
                }
                case Callback.AD_TYPE_YANDEX -> {
                    BannerAdView yBannerAd = new BannerAdView(ctx);
                    int width2 = ViewGroup.LayoutParams.MATCH_PARENT;
                    int heightPx2 = ctx.getResources().getDimensionPixelSize(R.dimen.banner_height);
                    yBannerAd.setLayoutParams(new FrameLayout.LayoutParams(width2, heightPx2));
                    yBannerAd.setAdUnitId(Callback.getYandexBannerAdID());
                    com.yandex.mobile.ads.common.AdRequest yadRequest = new com.yandex.mobile.ads.common.AdRequest.Builder().build();
                    linearLayout.addView(yBannerAd);
                    yBannerAd.loadAd(yadRequest);
                    return yBannerAd;
                }
                default -> {
                    return null;
                }
            }
        } else {
            return null;
        }
    }

    public void showInterAd(final int pos, final String type) {
        if (isInterAd()){
            switch (Callback.getAdNetwork()) {
                case Callback.AD_TYPE_ADMOB, Callback.AD_TYPE_META -> {
                    final AdManagerInterAdmob adManagerInterAdmob = new AdManagerInterAdmob(ctx);
                    if (adManagerInterAdmob.getAd() != null) {
                        adManagerInterAdmob.getAd().setFullScreenContentCallback(new FullScreenContentCallback() {
                            @Override
                            public void onAdDismissedFullScreenContent() {
                                AdManagerInterAdmob.setAd(null);
                                adManagerInterAdmob.createAd();
                                interAdListener.onClick(pos, type);
                                super.onAdDismissedFullScreenContent();
                            }

                            @Override
                            public void onAdFailedToShowFullScreenContent(@NonNull @NotNull com.google.android.gms.ads.AdError adError) {
                                AdManagerInterAdmob.setAd(null);
                                adManagerInterAdmob.createAd();
                                interAdListener.onClick(pos, type);
                                super.onAdFailedToShowFullScreenContent(adError);
                            }
                        });
                        adManagerInterAdmob.getAd().show((Activity) ctx);
                    } else {
                        AdManagerInterAdmob.setAd(null);
                        adManagerInterAdmob.createAd();
                        interAdListener.onClick(pos, type);
                    }
                }
                case Callback.AD_TYPE_STARTAPP -> {
                    final AdManagerInterStartApp adManagerInterStartApp = new AdManagerInterStartApp(ctx);
                    if (adManagerInterStartApp.getAd() != null && adManagerInterStartApp.getAd().isReady()) {
                        adManagerInterStartApp.getAd().showAd(new AdDisplayListener() {
                            @Override
                            public void adHidden(Ad ad) {
                                AdManagerInterStartApp.setAd(null);
                                adManagerInterStartApp.createAd();
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void adDisplayed(Ad ad) {
                                // this method is empty
                            }

                            @Override
                            public void adClicked(Ad ad) {
                                // this method is empty
                            }

                            @Override
                            public void adNotDisplayed(Ad ad) {
                                AdManagerInterStartApp.setAd(null);
                                adManagerInterStartApp.createAd();
                                interAdListener.onClick(pos, type);
                            }
                        });
                    } else {
                        AdManagerInterStartApp.setAd(null);
                        adManagerInterStartApp.createAd();
                        interAdListener.onClick(pos, type);
                    }
                }
                case Callback.AD_TYPE_UNITY -> {
                    final AdManagerInterUnity adManagerInterUnity = new AdManagerInterUnity();
                    if (AdManagerInterUnity.getAd()) {
                        UnityAds.show((Activity) ctx, Callback.getUnityInterstitialAdID(), new IUnityAdsShowListener() {
                            @Override
                            public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                                AdManagerInterUnity.setAd();
                                adManagerInterUnity.createAd();
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onUnityAdsShowStart(String placementId) {
                                // this method is empty
                            }

                            @Override
                            public void onUnityAdsShowClick(String placementId) {
                                // this method is empty
                            }

                            @Override
                            public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                                AdManagerInterUnity.setAd();
                                adManagerInterUnity.createAd();
                                interAdListener.onClick(pos, type);
                            }
                        });
                    } else {
                        AdManagerInterUnity.setAd();
                        adManagerInterUnity.createAd();
                        interAdListener.onClick(pos, type);
                    }
                }
                case Callback.AD_TYPE_APPLOVIN -> {
                    final AdManagerInterApplovin adManagerInterApplovin = new AdManagerInterApplovin(ctx);
                    if (adManagerInterApplovin.getAd() != null && adManagerInterApplovin.getAd().isReady()) {
                        adManagerInterApplovin.getAd().setListener(new MaxAdListener() {
                            @Override
                            public void onAdLoaded(@NonNull MaxAd ad) {
                                // this method is empty
                            }

                            @Override
                            public void onAdDisplayed(@NonNull MaxAd ad) {
                                // this method is empty
                            }

                            @Override
                            public void onAdHidden(@NonNull MaxAd ad) {
                                AdManagerInterApplovin.setAd(null);
                                adManagerInterApplovin.createAd();
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdClicked(@NonNull MaxAd ad) {
                                // this method is empty
                            }

                            @Override
                            public void onAdLoadFailed(@NonNull String adUnitId, @NonNull MaxError error) {
                                AdManagerInterApplovin.setAd(null);
                                adManagerInterApplovin.createAd();
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdDisplayFailed(@NonNull MaxAd ad, @NonNull MaxError error) {
                                AdManagerInterApplovin.setAd(null);
                                adManagerInterApplovin.createAd();
                                interAdListener.onClick(pos, type);
                            }
                        });
                        adManagerInterApplovin.getAd().showAd();
                    } else {
                        AdManagerInterStartApp.setAd(null);
                        adManagerInterApplovin.createAd();
                        interAdListener.onClick(pos, type);
                    }
                }
                case Callback.AD_TYPE_IRONSOURCE -> {
                    if (IronSource.isInterstitialReady()) {
                        IronSource.setLevelPlayInterstitialListener(new LevelPlayInterstitialListener() {
                            @Override
                            public void onAdReady(AdInfo adInfo) {
                                // this method is empty
                            }

                            @Override
                            public void onAdLoadFailed(IronSourceError ironSourceError) {
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdOpened(AdInfo adInfo) {
                                // this method is empty
                            }

                            @Override
                            public void onAdShowSucceeded(AdInfo adInfo) {
                                // this method is empty
                            }

                            @Override
                            public void onAdShowFailed(IronSourceError ironSourceError, AdInfo adInfo) {
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdClicked(AdInfo adInfo) {
                                // this method is empty
                            }

                            @Override
                            public void onAdClosed(AdInfo adInfo) {
                                interAdListener.onClick(pos, type);
                            }
                        });
                        IronSource.showInterstitial();
                    } else {
                        interAdListener.onClick(pos, type);
                    }
                    IronSource.init(ctx, Callback.getIronsourceAppKey(), IronSource.AD_UNIT.INTERSTITIAL);
                    IronSource.loadInterstitial();
                }
                case Callback.AD_TYPE_YANDEX -> {
                    final AdManagerInterYandex adManagerInterYandex = new AdManagerInterYandex(ctx);
                    if (adManagerInterYandex.getAd() != null) {
                        adManagerInterYandex.getAd().setAdEventListener(new InterstitialAdEventListener() {
                            @Override
                            public void onAdShown() {
                                // this method is empty
                            }

                            @Override
                            public void onAdFailedToShow(@NonNull AdError adError) {
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdDismissed() {
                                AdManagerInterYandex.setAd(null);
                                adManagerInterYandex.createAd();
                                interAdListener.onClick(pos, type);
                            }

                            @Override
                            public void onAdClicked() {
                                // this method is empty
                            }

                            @Override
                            public void onAdImpression(@Nullable ImpressionData impressionData) {
                                // this method is empty
                            }
                        });
                        adManagerInterYandex.getAd().show((Activity) ctx);
                    } else {
                        AdManagerInterYandex.setAd(null);
                        adManagerInterYandex.createAd();
                        interAdListener.onClick(pos, type);
                    }
                }
                default -> interAdListener.onClick(pos, type);
            }
        } else {
            interAdListener.onClick(pos, type);
        }
    }

    public void showRewardAds(int pos, RewardAdListener rewardAdListener) {
        if (Boolean.TRUE.equals(Callback.getIsRewardAd())
                && Boolean.TRUE.equals(Callback.getIsAdsStatus())
                && !new SPHelper(ctx).getIsSubscribed()) {
            if (Boolean.TRUE.equals(new SPHelper(ctx).getIsRewardAdWarned())) {
                loadRewardAds(rewardAdListener, pos);
            } else {
                openRewardVideoAdAlert(rewardAdListener, pos);
            }
        } else {
            rewardAdListener.onPurchases(pos);
        }
    }

    public void loadRewardAds(RewardAdListener rewardAdListener, int pos) {
        if (!new GDPRChecker(ctx).canLoadAd()) {
            rewardAdListener.onClick(false, pos);
            return;
        }

        switch (Callback.getAdNetwork()) {
            case Callback.AD_TYPE_ADMOB:
                final RewardAdAdmob rewardAdAdmob = new RewardAdAdmob(ctx);
                if (rewardAdAdmob.getAd() != null) {
                    rewardAdAdmob.getAd().setFullScreenContentCallback(new FullScreenContentCallback() {
                        @Override
                        public void onAdDismissedFullScreenContent() {
                            RewardAdAdmob.setAd(null);
                            rewardAdAdmob.createAd();
                            if (isRewarded) {
                                rewardAdListener.onClick(true, pos);
                            }
                            super.onAdDismissedFullScreenContent();
                        }

                        @Override
                        public void onAdFailedToShowFullScreenContent(@NonNull @NotNull com.google.android.gms.ads.AdError adError) {
                            RewardAdAdmob.setAd(null);
                            rewardAdAdmob.createAd();
                            rewardAdListener.onClick(false, pos);
                            super.onAdFailedToShowFullScreenContent(adError);
                        }
                    });
                    rewardAdAdmob.getAd().show((Activity) ctx, rewardItem -> isRewarded = true);
                } else {
                    RewardAdAdmob.setAd(null);
                    rewardAdAdmob.createAd();
                    rewardAdListener.onClick(false, pos);
                }
                break;
            case Callback.AD_TYPE_STARTAPP:
                final RewardAdStartApp rewardAdStartApp = new RewardAdStartApp(ctx);
                if (rewardAdStartApp.getAd() != null && rewardAdStartApp.getAd().isReady()) {
                    rewardAdStartApp.getAd().showAd(new AdDisplayListener() {
                        @Override
                        public void adHidden(Ad ad) {
                            RewardAdStartApp.setAd(null);
                            rewardAdStartApp.createAd();
                            if (isRewarded) {
                                rewardAdListener.onClick(true, pos);
                            }
                        }

                        @Override
                        public void adDisplayed(Ad ad) {
                            // this method is empty
                        }

                        @Override
                        public void adClicked(Ad ad) {
                            // this method is empty
                        }

                        @Override
                        public void adNotDisplayed(Ad ad) {
                            RewardAdStartApp.setAd(null);
                            rewardAdStartApp.createAd();
                            rewardAdListener.onClick(false, pos);
                        }
                    });
                    rewardAdStartApp.getAd().setVideoListener(() -> isRewarded = true);
                } else {
                    RewardAdStartApp.setAd(null);
                    rewardAdStartApp.createAd();
                    rewardAdListener.onClick(false, pos);
                }
                break;
            case Callback.AD_TYPE_APPLOVIN:
                final RewardAdApplovin rewardAdApplovin = new RewardAdApplovin(ctx);
                if (RewardAdApplovin.getAd() != null && RewardAdApplovin.getAd().isReady()) {
                    RewardAdApplovin.getAd().setListener(new MaxRewardedAdListener() {


                        @Override
                        public void onAdLoaded(@NonNull MaxAd maxAd) {
                            // this method is empty
                        }

                        @Override
                        public void onAdDisplayed(@NonNull MaxAd maxAd) {
                            // this method is empty
                        }

                        @Override
                        public void onAdHidden(@NonNull MaxAd maxAd) {
                            RewardAdApplovin.setAd(null);
                            rewardAdApplovin.createAd();
                            if (isRewarded) {
                                rewardAdListener.onClick(true, pos);
                            }
                        }

                        @Override
                        public void onAdClicked(@NonNull MaxAd maxAd) {
                            // this method is empty
                        }

                        @Override
                        public void onAdLoadFailed(@NonNull String s, @NonNull MaxError maxError) {
                            RewardAdApplovin.setAd(null);
                            rewardAdApplovin.createAd();
                            rewardAdListener.onClick(false, pos);
                        }

                        @Override
                        public void onAdDisplayFailed(@NonNull MaxAd maxAd, @NonNull MaxError maxError) {
                            RewardAdApplovin.setAd(null);
                            rewardAdApplovin.createAd();
                            rewardAdListener.onClick(false, pos);
                        }

                        @Override
                        public void onUserRewarded(@NonNull MaxAd maxAd, @NonNull MaxReward maxReward) {
                            isRewarded = true;
                        }
                    });
                    RewardAdApplovin.getAd().showAd();
                } else {
                    RewardAdApplovin.setAd(null);
                    rewardAdApplovin.createAd();
                    rewardAdListener.onClick(false, pos);
                }
                break;
            case Callback.AD_TYPE_UNITY:
                final RewardAdUnity rewardAdUnity = new RewardAdUnity();
                if (RewardAdUnity.getAd()) {
                    UnityAds.show((Activity) ctx, Callback.getUnityRewardAdID(), new IUnityAdsShowListener() {
                        @Override
                        public void onUnityAdsShowFailure(String placementId, UnityAds.UnityAdsShowError error, String message) {
                            RewardAdUnity.setAd(false);
                            rewardAdUnity.createAd();
                            rewardAdListener.onClick(false, pos);
                        }

                        @Override
                        public void onUnityAdsShowStart(String placementId) {
                            // this method is empty
                        }

                        @Override
                        public void onUnityAdsShowClick(String placementId) {
                            // this method is empty
                        }

                        @Override
                        public void onUnityAdsShowComplete(String placementId, UnityAds.UnityAdsShowCompletionState state) {
                            RewardAdUnity.setAd(false);
                            rewardAdUnity.createAd();
                            rewardAdListener.onClick(true, pos);
                        }
                    });
                } else {
                    RewardAdUnity.setAd(false);
                    rewardAdUnity.createAd();
                    rewardAdListener.onClick(false, pos);
                }
                break;
            default:
                break;
        }
    }

    public void openRewardVideoAdAlert(RewardAdListener rewardAdListener, int pos) {
        @SuppressLint("InflateParams") View view = ((Activity) ctx).getLayoutInflater().inflate(R.layout.row_bottom_videoad, null);

        BottomSheetDialog dialog = new BottomSheetDialog(ctx);
        dialog.setContentView(view);
        dialog.show();

        SmoothCheckBox smoothCheckBox = dialog.findViewById(R.id.cb_videoad);

        TextView logout = dialog.findViewById(R.id.btn_bottom_logout);
        if (logout != null){
            logout.setOnClickListener(view1 -> {
                dialog.dismiss();
                if (smoothCheckBox != null){
                    new SPHelper(ctx).setIsRewardAdWarned(smoothCheckBox.isChecked());
                } else {
                    new SPHelper(ctx).setIsRewardAdWarned(false);
                }
                loadRewardAds(rewardAdListener, pos);
            });
        }

        TextView cancel = dialog.findViewById(R.id.btn_bottom_cancel);
        if (cancel != null){
            cancel.setOnClickListener(view1 -> dialog.dismiss());
        }

        LinearLayout checkbox = dialog.findViewById(R.id.ll_checkbox);
        if (checkbox != null){
            checkbox.setOnClickListener(view1 -> {
                if (smoothCheckBox != null){
                    smoothCheckBox.setChecked(true);
                }
            });
        }

        TextView subscribe = dialog.findViewById(R.id.btn_bottom_subscribe);
        if (subscribe != null){
            subscribe.setOnClickListener(v -> DialogUtil.premiumDialog((Activity) ctx));
        }

        dialog.show();
    }

    private boolean isInterAd() {
        if (NetworkUtils.isConnected(ctx) && Boolean.TRUE.equals(Callback.getIsInterAd())
                && Boolean.TRUE.equals(Callback.getIsAdsStatus())
                && new GDPRChecker(ctx).canLoadAd()
                && !new SPHelper(ctx).getIsSubscribed()) {
            Callback.setAdCount(Callback.getAdCount() + 1);
            return Callback.getAdCount() % Callback.getInterstitialAdShow() == 0;
        } else {
            return false;
        }
    }

    private boolean isBannerAd(String page) {
        if (NetworkUtils.isConnected(ctx) && Boolean.TRUE.equals(Callback.getIsAdsStatus())
                && new GDPRChecker(ctx).canLoadAd()
                && !new SPHelper(ctx).getIsSubscribed()) {
            return switch (page) {
                case Callback.PAGE_HOME -> Callback.getIsBannerAdHome();
                case Callback.PAGE_POST_DETAILS -> Callback.getIsBannerAdPostDetails();
                case Callback.PAGE_CAT_DETAILS -> Callback.getIsBannerAdCatDetails();
                case Callback.PAGE_SEARCH -> Callback.getIsBannerAdSearch();
                default -> true;
            };
        } else {
            return false;
        }
    }

    public boolean canLoadNativeAds(Context context, String page) {
        if (Boolean.TRUE.equals(Callback.getIsAdsStatus())
                && new GDPRChecker(context).canLoadAd()
                && !new SPHelper(ctx).getIsSubscribed()) {
            if (page.equals(Callback.PAGE_NATIVE_POST)){
                return Callback.getIsNativeAdPost();
            } else if (page.equals(Callback.PAGE_NATIVE_CAT)){
                return Callback.getIsNativeAdCat();
            } else {
                return false;
            }
        } else {
            return false;
        }
    }

    public void clickLogin() {
        SPHelper spHelper = new SPHelper(ctx);
        if (spHelper.isLogged()) {
            logout((Activity) ctx, spHelper);
            Toast.makeText(ctx, ctx.getString(R.string.logout_success), Toast.LENGTH_SHORT).show();
        } else {
            Intent intent = new Intent(ctx, SignInActivity.class);
            intent.putExtra("from", "app");
            ctx.startActivity(intent);
        }
    }

    public void logout(Activity activity, SPHelper spHelper) {
        if (spHelper != null){
            if (spHelper.getLoginType().equals(Method.LOGIN_TYPE_GOOGLE)) {
                FirebaseAuth.getInstance().signOut();
            }
            spHelper.setIsAutoLogin(false);
            spHelper.setIsLogged(false);
            spHelper.setLoginDetails("", "", "", "", "", "",
                    "", false, "", Method.LOGIN_TYPE_NORMAL);
        }
        Intent intent1 = new Intent(ctx, SignInActivity.class);
        intent1.setFlags(Intent.FLAG_ACTIVITY_NEW_TASK | Intent.FLAG_ACTIVITY_CLEAR_TASK);
        intent1.putExtra("from", "");
        ctx.startActivity(intent1);
        activity.finish();
    }
}
